## Connection Profiles and AAA Methods

### Purpose of Connection Profiles

- Used to group users/sites requiring different AAA (Authentication, Authorization, and Accounting) methods.
- Examples:
    - One profile for users authenticating with digital certificate, username, and OTP via RADIUS.
    - Another profile for users using only username and password via RADIUS.
- Stronger AAA methods are recommended for users accessing sensitive resources.
- Weaker AAA controls can be used for users with limited access, such as external partners.

---

## When to Use Multiple or Single Connection Profiles

- **Multiple Profiles:**
    - Required when users/sites need different AAA methods.
- **Single Profile:**
    - Sufficient if all users use the same authentication method, even if their post-login policies differ.
    - Post-login policies can be applied or overridden via user local accounts or AAA server.

---

## Methods for Selecting Connection Profiles

### User-Driven Selection

- **By Alias:**
    - User specifies the connection profile alias in the Cisco Secure Client GUI when entering the VPN headend URL.
- **Drop-Down Menu:**
    - User selects a profile from a menu before authentication.

### Admin-Configured Experience

- **XML Profile Configuration:**
    - Network administrators can pre-configure Cisco Secure Client with the VPN headend URL and a connection profile for user convenience.

### Automated Selection

- **Certificate-Based Mapping:**
    - VPN headend can auto-select connection profiles based on digital certificate fields (e.g., organization unit).
    - Example:
        - "IT" in certificate maps to IT connection profile.
        - "Sales" in certificate maps to Sales connection profile.

---

## Default Connection Profile

- **Fallback Mechanism:**
    - If user cannot or does not select a profile, or certificate mapping fails, user is placed in the default connection profile (DefaultWEBVPNGroup).
- **Customizable:**
    - Default profile can be modified and used like any other profile.
- **Use Case:**
    - Suitable when no differentiated AAA is required—only a single profile is needed.

### Platform Differences

- **Cisco Secure Firewall ASA:**
    - Default profile uses the local user database for authentication and is ready to use.
- **Cisco Secure Firewall Threat Defense:**
    - Default profile lacks a pre-assigned AAA method and must be configured before use.

---

## Connection Profile Settings

- Both Cisco Secure Firewall Threat Defense and Cisco Secure Firewall ASA provide similar options for connection profiles.
- Options are organized differently across platforms.